status_t g400_init_powerup();


/*common functions*/
void delay(bigtime_t i);
void LOG(int level,char * message, ...);

/*card info functions*/
status_t g400_read_pins();

/*DAC functions*/
status_t g400_dac_mode(int,float);
status_t g400_dac_palette(uint8*,uint8*,uint8*);

status_t g400_dac_cursor_init();
status_t g400_dac_cursor_define(uint8*,uint8*);
status_t g400_dac_cursor_position(uint16 x ,uint16 y);
status_t g400_dac_cursor_show();
status_t g400_dac_cursor_hide();

status_t g400_dac_pix_pll_find(float f_vco,float * result,uint8 *,uint8 *,uint8 *);
status_t g400_dac_set_pix_pll(float f_vco);
status_t g400_dac_set_sys_pll(int,int,int,int);


/*CRTC functions*/
status_t g400_crtc_validate_timing(
	uint16 *hd_e,uint16 *hs_s,uint16 *hs_e,uint16 *ht,
	uint16 *vd_e,uint16 *vs_s,uint16 *vs_e,uint16 *vt
);
status_t g400_crtc_set_timing(
	uint16 hd_e,uint16 hs_s,uint16 hs_e,uint16 ht,
	uint16 vd_e,uint16 vs_s,uint16 vs_e,uint16 vt,
	uint8 hsync_pos,uint8 vsync_pos
);
status_t g400_crtc_set_display_start(uint32 startadd,uint8 bpp); 
status_t g400_crtc_set_display_pitch(uint32 pitch,uint8 bpp);

status_t g400_crtc_dpms(uint8,uint8,uint8);
status_t g400_crtc_dpms_fetch(uint8*,uint8*,uint8*);
status_t g400_crtc_mem_priority(uint8);

/*acceleration functions*/
status_t g400_acc_init();
status_t g400_acc_rectangle(uint32 xs,uint32 xe,uint32 ys,uint32 yl,uint32 col);
status_t g400_acc_rectangle_invert(uint32 xs,uint32 xe,uint32 ys,uint32 yl,uint32 col);
status_t g400_acc_blit(uint16,uint16,uint16, uint16,uint16,uint16 );
status_t g400_acc_wait_idle();

/*driver structures and enums*/
enum{BPP8=0,BPP15=1,BPP16=2,BPP24=3,BPP32DIR=4,BPP32=7};

