/*Macros for convenient accesses to the G400*/

#define bytewrite ((uint8 *)regs)

/*read and write to PCI config space*/
#define CFGR(A) (g400_pci_access.offset= MGACFG_##A ,ioctl(fd,G400_GET_PCI,&g400_pci_access,sizeof(g400_pci_access)),g400_pci_access.value)
#define CFGW(A,B) (g400_pci_access.offset= MGACFG_##A , g400_pci_access.value= B , ioctl(fd,G400_SET_PCI,&g400_pci_access,sizeof(g400_pci_access)))

/*read and write from the dac registers*/
#define DACR(A) (bytewrite[MGADAC_##A])
#define DACW(A,B) (bytewrite[MGADAC_##A]=B)

/*read and write from the dac index register*/
#define DXIR(A) (DACW(PALWTADD,MGADXI_##A),DACR(X_DATAREG))
#define DXIW(A,B) (DACW(PALWTADD,MGADXI_##A),DACW(X_DATAREG,B))

/*read and write from the vga registers*/
#define VGAR(A) (bytewrite[MGAVGA_##A])
#define VGAW(A,B) (bytewrite[MGAVGA_##A]=B)

/*read and write from the indexed vga registers*/
#define VGAR_I(A,B) (VGAW(A##_I,B),VGAR(A##_D))
#define VGAW_I(A,B,C) (VGAW(A##_I,B),VGAW(A##_D,C))

/*read and write from the powergraphics register*/
#define ACCR(A) (regs[MGAACC_##A >>2])
#define ACCW(A,B) (regs[MGAACC_##A >>2]=B)
#define ACCGO(A,B) (regs[(MGAACC_##A +0x100)>>2]=B)

/*read and write from second CRTC*/
#define CR2R(A) (regs[MGACR2_##A >>2])
#define CR2W(A,B) (regs[MGACR2_##A >>2]=B)
