/*MGAG400 registers*/

/*PCI_config_space*/
const unsigned char
MGACFG_DEVID    =0x00,
MGACFG_DEVCTRL  =0x04,
MGACFG_CLASS    =0x08,
MGACFG_HEADER   =0x0c,
MGACFG_MGABASE2 =0x10,
MGACFG_MGABASE1 =0x14,
MGACFG_MGABASE3 =0x18,
MGACFG_SUBSYSIDR=0x2c,
MGACFG_ROMBASE  =0x30,
MGACFG_CAP_PTR  =0x34,
MGACFG_INTCTRL  =0x3c,
MGACFG_OPTION   =0x40,
MGACFG_MGA_INDEX=0x44,
MGACFG_MGA_DATA =0x48,
MGACFG_SUBSYSIDW=0x4c,
MGACFG_OPTION2  =0x50,
MGACFG_OPTION3  =0x54,
MGACFG_PM_IDENT =0xdc,
MGACFG_PM_CSR   =0xe0,
MGACFG_AGP_IDENT=0xf0,
MGACFG_AGP_STS  =0xf4,
MGACFG_AGP_CMD  =0xf8;

/*VGA registers - these are byte wide*/
const unsigned short
MGAVGA_MISCW    =0x1FC2,
MGAVGA_SEQ_I    =0x1FC4,
MGAVGA_SEQ_D    =0x1FC5,
MGAVGA_DACSTAT  =0x1FC7,
MGAVGA_FEATR    =0x1FCA,
MGAVGA_MISCR    =0x1FCC,
MGAVGA_GCTL_I   =0x1FCE,
MGAVGA_GCTL_D   =0x1FCF,
MGAVGA_CRTC_I   =0x1FD4,
MGAVGA_CRTC_D   =0x1FD5,
MGAVGA_INSTS1   =0x1FDA,
MGAVGA_FEATW    =0x1FDA,
MGAVGA_CRTCEXT_I=0x1FDE,
MGAVGA_CRTCEXT_D=0x1FDF;

/*DAC registers*/
const unsigned short
MGADAC_PALWTADD =0x3C00,
MGADAC_PALDATA  =0x3C01,
MGADAC_PIXRDMSK =0x3C02,
MGADAC_PALRDADD =0x3C03,
MGADAC_X_DATAREG=0x3C0A,
MGADAC_CURSPOSXL=0x3C0C,
MGADAC_CURSPOSXH=0x3C0D,
MGADAC_CURSPOSYL=0x3C0E,
MGADAC_CURSPOSYH=0x3C0F;

/*(D)AC (X) (I)ndexed registers*/
const unsigned char
MGADXI_CURADDL     =0x04,
MGADXI_CURADDH     =0x05,
MGADXI_CURCTRL     =0x06,
MGADXI_CURCOL0RED  =0x08,
MGADXI_CURCOL0GREEN=0x09,
MGADXI_CURCOL0BLUE =0x0A,
MGADXI_CURCOL1RED  =0x0C,
MGADXI_CURCOL1GREEN=0x0D,
MGADXI_CURCOL1BLUE =0x0E,
MGADXI_CURCOL2RED  =0x10,
MGADXI_CURCOL2GREEN=0x11,
MGADXI_CURCOL2BLUE =0x12,
MGADXI_VREFCTRL    =0x18,
MGADXI_MULCTRL     =0x19,
MGADXI_PIXCLKCTRL  =0x1A,
MGADXI_GENCTRL     =0x1D,
MGADXI_MISCCTRL    =0x1E,
MGADXI_PANELMODE   =0x1F,
MGADXI_MAFCDEL     =0x20,
MGADXI_GENIOCTRL   =0x2A,
MGADXI_GENIODATA   =0x2B,
MGADXI_SYSPLLM     =0x2C,
MGADXI_SYSPLLN     =0x2D,
MGADXI_SYSPLLP     =0x2E,
MGADXI_SYSPLLSTAT  =0x2F,
MGADXI_ZOOMCTRL    =0x38,
MGADXI_SENSETEST   =0x3A,
MGADXI_CRCREML     =0x3C,
MGADXI_CRCREMH     =0x3D,
MGADXI_CRCBITSEL   =0x3E,
MGADXI_COLMSK      =0x40,
MGADXI_COLKEY      =0x42,
MGADXI_PIXPLLAM    =0x44,
MGADXI_PIXPLLAN    =0x45,
MGADXI_PIXPLLAP    =0x46,
MGADXI_PIXPLLBM    =0x48,
MGADXI_PIXPLLBN    =0x49,
MGADXI_PIXPLLBP    =0x4A,
MGADXI_PIXPLLCM    =0x4C,
MGADXI_PIXPLLCN    =0x4D,
MGADXI_PIXPLLCP    =0x4E,
MGADXI_PIXPLLSTAT  =0x4F,
MGADXI_CURCOLEXT   =0x60;   /*sequential from CURCOL3->15, RGB*/

/*MGA 2nd CRTC registers*/
const unsigned short
MGACR2_CTL       =0x3C10,
MGACR2_HPARAM    =0x3C14,
MGACR2_HSYNC     =0x3C18,
MGACR2_VPARAM    =0x3C1C,
MGACR2_VSYNC     =0x3C20,
MGACR2_PRELOAD   =0x3C24,
MGACR2_STARTADD0 =0x3C28,
MGACR2_OFFSET    =0x3C40,
MGACR2_MISC      =0x3C44,
MGACR2_VCOUNT    =0x3C48,
MGACR2_DATACTL   =0x3C4C;

/*MGA ACCeleration registers*/
const unsigned short
MGAACC_DWGCTL      =0x1C00,
MGAACC_MACCESS     =0x1C04,
MGAACC_MCTLWTST    =0x1C08,
MGAACC_PLNWT       =0x1C1C,
MGAACC_FCOL        =0x1C24,
MGAACC_SGN         =0x1C58,
MGAACC_LEN         =0x1C5C,
MGAACC_AR0         =0x1C60,
MGAACC_AR3         =0x1C6C,
MGAACC_AR5         =0x1C74,
MGAACC_CXBNDRY     =0x1C80,
MGAACC_FXBNDRY     =0x1C84,
MGAACC_YDSTLEN     =0x1C88,
MGAACC_PITCH       =0x1C8C,
MGAACC_YDST        =0x1C90,
MGAACC_YTOP        =0x1C98,
MGAACC_YBOT        =0x1C9C,
MGAACC_CXLEFT      =0x1CA0,
MGAACC_CXRIGHT     =0x1CA4,
MGAACC_FXLEFT      =0x1CA8,
MGAACC_FXRIGHT     =0x1CAC,
MGAACC_MEMRDBK     =0x1E44,
MGAACC_DWGSYNC     =0x2C4C,
MGAACC_SRCORG      =0x2CB4,
MGAACC_STATUS      =0x1E14,
MGAACC_DSTORG      =0x2CB8;

