/*initialise the G400 hardware*/
/*Mark Watson 12/1999*/

#include "mga_std.h"

status_t g400_init_powerup()
{
	/*power up the PLLs,LUT,DAC*/
	/*this bit should not be needed if BIOS has initialised it*/
	LOG(1,"INIT:PLL/LUT/DAC powerup\n");
	DXIW(VREFCTRL,0x30);                /*set voltage reference - using DAC reference block*/
	delay(100000);                      /*wait for 100ms for voltage reference to stabalise*/
	CFGW(OPTION,CFGR(OPTION)|0x20);     /*power up the SYSPLL - sets syspllpdN to 1*/
	while(!(DXIR(SYSPLLSTAT)&0x40));    /*wait for the SYSPLL frequency to lock*/
	LOG(2,"INIT: SYS PLL locked\n");
	DXIW(PIXCLKCTRL,0x08);              /*power up the PIXPLL - sets pixpllpdN to 1*/
	while(!(DXIR(PIXPLLSTAT)&0x40));    /*wait for the PIXPLL frequency to lock*/
	LOG(2,"INIT: PIX PLL locked\n");
	DXIW(MISCCTRL,0x19);

	/*read the PINS*/
	if (g400_read_pins()==B_ERROR)
		return B_ERROR;

	/*make sure card is in powergraphics mode*/
	VGAW_I(CRTCEXT,3,0x80);      

	/*enable writing to crtc registers*/
	VGAW_I(CRTC,0x11,0);

	/*set the system clocks to powergraphics speed*/
	LOG(1,"INIT:Setting SYS/PIX plls to powergraphics speeds\n");
	g400_dac_set_sys_pll
	(
		si->ps.syspll_m,
		si->ps.syspll_n,
		si->ps.syspll_mclk_div,
		si->ps.syspll_oclk_div
	);

	/*select a boring PIXPLL for now*/
	g400_dac_set_pix_pll(27.0);

	/*SGRAM initialisation - SDRAM not supported yet*/
	LOG(1,"INIT:SGRAM init\n");
	VGAW_I(SEQ,1,0x20);                                             /*set scroff blanking field - turns off display1*/
	ACCW(MCTLWTST,si->ps.mem_ctl);                                  /*set memory wait states*/
	CFGW(OPTION,(CFGR(OPTION)&0xFFFF83FF)|si->ps.mem_type);         /*set RAM type and config*/
	ACCW(MEMRDBK,(ACCR(MEMRDBK)&0xFFFF)|(si->ps.mem_rd&0xFFFF0000));/*set MEMRDBK - mrsopcode*/
	delay(250);                                                     /*wait for 250microseconds*/
	ACCW(MACCESS,ACCR(MACCESS)&0xFFFF7FFF);                         /*reset memory*/          
	ACCW(MACCESS,ACCR(MACCESS)|0x8000);             
	delay(250);                                                     /*wait for 250microseconds*/
	ACCW(MEMRDBK,(ACCR(MEMRDBK)&0xFFFF0000)|(si->ps.mem_rd&0xFFFF));/*set tap delays*/
	CFGW(OPTION,(CFGR(OPTION)&0xffe07fff)|(si->ps.mem_rfhcnt<<15)); /*start memory refresh*/

	/*Bus parameters*/
	CFGW(OPTION,(CFGR(OPTION)|(1<<22)|(1<<29)));                    /*disable retries, use advanced read*/

	/*turn on the screen*/
	g400_crtc_dpms(1,1,1);

	return B_OK;
}
