/*Read initialisation information from card*/
/*some bits are hacks, where PINS is not known*/
/*Mark Watson 2/2000*/

#include "mga_std.h"

enum 	{
	id=0x00,
	length=0x02,
	version=0x04,
	cardtype=0x0a,
	memtype=0x35,
	memctl=0x3d,
	memrd=0x56,
	sdram=0x5c
	};

/*word out card specific information*/
status_t g400_read_pins()
{
	unsigned char * rom;
	unsigned short pins;
	int i;
	int chksum = 0;

	LOG(1,"INFO:Reading PINS info\n");
	
	/*get a nice pointer*/
	rom = (unsigned char *) si->rom_mirror;

	/*check BIOS extension signiture*/
	if (rom[0]==0x55 && rom[1]==0xaa)
	{
		LOG(2,"INFO:BIOS signiture $AA55 found OK\n");
	}
	else
	{
		LOG(3,"INFO:BIOS signiture not found\n");
		return B_ERROR;
	}

	/*attempt to find PINS*/
	pins = rom[0x7FFC]|(rom[0x7FFD]<<8);
	LOG(2,"INFO:Using PINS v%d.%d structure at: %x\n",rom[pins+version+1],rom[pins+version],pins);

	/*check validity*/
	for (i=0;i<rom[pins+length];i++)
	{
		chksum+=rom[pins+i];
	}
	if(chksum%256)
	{
		LOG(3,"INFO:PINS checksum is incorrect\n");
		return B_ERROR;
	}
	else	
	{
		LOG(2,"INFO:PINS checksum is correct\n");
	}

	/*read memory control word*/
	si->ps.mem_ctl=(rom[pins+memctl])|(rom[pins+memctl+1]<<8)|(rom[pins+memctl+2]<<16)|(rom[pins+memctl+3]<<24);
	LOG(2,"INFO:Memory control word: %x\n",si->ps.mem_ctl);

	/*read memory config*/
	si->ps.sdram = ((rom[pins+sdram]&0x10)>>4);
	if (si->ps.sdram)
	{
		LOG(2,"INFO:SDRAM card detected\n");
	}
	else
	{
		LOG(2,"INFO:SGRAM card detected\n");
	}
	si->ps.mem_type=((rom[pins+memtype]&0x38)<<7)|((!si->ps.sdram)<<14);
	LOG(2,"INFO:Memory config: %x\n",si->ps.mem_type);

	/*calculate how much RWM is available from memory config*/
	switch((si->ps.mem_type>>0x10)&0x7)
	{
	case 0:
		si->ps.mem_size = 16*1024*1024*(1+((si->ps.mem_type&0x4000)>0));
		break;
	case 1:case 2:
		si->ps.mem_size = 16*1024*1024;
		break;
	case 3:case 5:
		si->ps.mem_size = 64*1024*1024;
		break;
	case 4:
		si->ps.mem_size = 32*1024*1024;
		break;
	default:
		LOG(3,"INFO:memory size detection failed, guessing 16MB\n");
		si->ps.mem_size = 16*1024*1024;
		break;
	}
	LOG(2,"INFO:memory detected: %dMB\n",si->ps.mem_size/(1024*1024));

	/*figure out memrdbk settings*/
	si->ps.mem_rd=((rom[pins+memrd+1]&0xf0)>>3)<<24|((rom[pins+memrd+1]&0x03)>>2)<<16;
	si->ps.mem_rd|=((rom[pins+memrd]&0xf0)<<1)|(rom[pins+memrd]&0x0f);
	LOG(2,"INFO:MEMRDBK setting: %x\n",si->ps.mem_rd);

	/*figure out if it is a G400MAX or vanilla G400*/
	/*FIXME, use the correct ID method!*/
	if (si->ps.mem_ctl==0x24045491)
	{
		LOG(2,"INFO:Card is a G400\n");
		si->ps.card_type=1;
	}
	else if (si->ps.mem_ctl==0x20049911)
	{
		LOG(2,"INFO:Card is a G400MAX\n");
		si->ps.card_type=2;
	}
	else /*to reduce any initial problems with different words*/
	{
		LOG(3,"INFO:Unknown control word, presuming plain G400\n");
		si->ps.card_type=1;
	}

	/*FIXME hardcode a few required values!*/
	/*presume at least 16MB - I do not know how to detect (no great loss for 32MB in 2D)*/
	/*system clock settings*/
	/*memory refresh settings (values pinched from windows)*/
	if (si->ps.card_type==1)
	{
		si->ps.pix_clk_max=300000000;
		si->ps.syspll_m=2;
		si->ps.syspll_n=27;
		si->ps.syspll_mclk_div=4;
		si->ps.syspll_oclk_div=3;
		si->ps.mem_clk_period = 1000.0/126.0;
		si->ps.mem_rfhcnt=0x27;
	}
	else if (si->ps.card_type==2)
	{
		si->ps.pix_clk_max=360000000;
		si->ps.syspll_m=5;
		si->ps.syspll_n=66;
		si->ps.syspll_mclk_div=4;
		si->ps.syspll_oclk_div=3;
		si->ps.mem_clk_period = 1000.0/150.0;
		si->ps.mem_rfhcnt=0x2e;
	}

	return B_OK;
}
