/*second CTRC functionality*/
/*Mark Watson 2/2000*/
/*non-functional - experimental*/

#include "mga_std.h"

status_t g400_crtc2_init()
{
	/*set up general control registers*/
	CR2W(DATACTL,0x00000000);

	/*turn on the screen*/
	g400_crtc2_dpms(1,1,1); 

	return B_OK;
}

/*verify and set a mode line - inputs are in pixels/scanlines*/
/*FIXME - remove excess stuff from here!*/
status_t g400_crtc2_set_timing(
	uint32 hdisp_e,uint32 hsync_s,uint32 hsync_e,uint32 htotal,
	uint32 vdisp_e,uint32 vsync_s,uint32 vsync_e,uint32 vtotal,
	uint8 hsync_pos,uint8 vsync_pos
	)
{
	int i;

	LOG(1,"CRTC2: setting timing\n");

	/*check horizontal timing parameters are to nearest 8 pixels*/
	if ((hdisp_e&7)|(hsync_s&7)|(hsync_e&7)|(htotal&7))
	{
		LOG(3,"CRTC2:Horizontal timings are not multiples of 8 pixels\n");
		return B_ERROR;
	}

	/*adjust values as required by spec*/
	hsync_s-=8;
	hsync_e-=8;
	htotal -=8;
	hdisp_e-=8;

	vsync_s-=1;
	vsync_e-=1;
	vtotal -=1;
	vdisp_e-=1;

	/*check it is within required number of bits - why bother?*/
	if (
		(htotal != (htotal &0xFFF)) ||
		(hdisp_e!= (hdisp_e&0xFFF)) ||
		(hsync_s!= (hsync_e&0xFFF)) ||
		(hsync_e!= (hsync_s&0xFFF)) ||
	        (vtotal != (vtotal &0xFFF)) ||
	        (vdisp_e!= (vdisp_e&0xFFF)) ||
	        (vsync_s!= (vsync_s&0xFFF)) ||
	        (vsync_e!= (vsync_e&0xFFF))
	)
	{
		LOG(3,"CRTC:Timing values are too high\n");
	}

	/*if all went well, then actually program the timing*/
	/*horizontal*/
	CR2W(HSYNC,(hsync_e<<16)|(hsync_s));
	CR2W(HPARAM,(hdisp_e<<16)|(htotal));

	/*vertical*/
	CR2W(VSYNC,(vsync_e<<16)|(vsync_e));
	CR2W(VPARAM,(vdisp_e<<16)|(vtotal));

	/*setting up HSYNC & VSYNC polarity*/
	CR2W(MISC,(CR2R(MISC)&0x0FFF0077)|((!vsync_pos)<<9)|((!hsync_pos)<<8));
	LOG(2,"CRTC2:HSYNC/VSYNC pol:%x %x MISC dump:%x\n",hsync_pos,vsync_pos,CR2R(MISC));

	return B_OK;
}

status_t g400_crtc2_dpms(uint8 display,uint8 h,uint8 v)
{
	CR2W(CTL,CR2R(CTL)|display|(1<<20)); /*enable second CRTC if required*/

	/*ignore h,v because they are not supported*/
	return B_OK;
}

status_t g400_crtc2_dpms_fetch(uint8 * display,uint8 * h,uint8 * v)
{
	*display=!((VGAR_I(SEQ,1)&0x20)>>5);

	*h=*v=1; /*h/vsync always enabled on second CRTC, does not support other*/

	return B_OK;
}

status_t g400_crtc2_set_display_pitch(uint32 pitch,uint8 bpp) 
{
	uint32 offset;

	LOG(1,"CRTC2: setting card pitch (offset between lines)\n");

	/*figure out offset value hardware needs*/
	offset = (pitch*bpp)/128;

	LOG(2,"CRTC2: offset: %x\n",offset);

	/*program the card!*/
	VGAW_I(CRTC,0x13,(offset&0xFF));
	VGAW_I(CRTCEXT,0,(VGAR_I(CRTCEXT,0)&0xCF)|((offset&0x300)>>4));
	return B_OK;
}

status_t g400_crtc2_set_display_start(uint32 startadd,uint8 bpp) 
{
	LOG(1,"CRTC2: setting card RAM to be displayed\n");

	startadd>>=3;

	LOG(2,"CRTC2: startadd: %x\n",startadd);
	LOG(2,"CRTC2: frameRAM: %x\n",si->framebuffer);
	LOG(2,"CRTC2: framebuffer: %x\n",si->fbc.frame_buffer);

	/*program the card!*/
	VGAW_I(CRTC,0xD,startadd&0xFF);
	VGAW_I(CRTC,0xC,(startadd&0xFF00)>>8);
	VGAW_I(CRTCEXT,8,((startadd&0x200000)>>21));
	VGAW_I(CRTCEXT,0,(VGAR_I(CRTCEXT,0)&0xB0)|((startadd&0xF0000)>>16)|((startadd&0x10000)>>14));
	return B_OK;
}
