/*G400 Acceleration functions*/
/*Mark Watson 2/2000*/

#include "mga_std.h"

/*acceleration notes*/

/*functions Be needs:
fill span (horizontal only)
fill rectangle (these 2 are very similar)
invert rectangle 
blit
*/

status_t g400_acc_wait_idle()
{
	volatile int i;
	while (ACCR(STATUS)&(1<<16))
	{
		for (i=0;i<10000;i++);
	};
	return B_OK;
}

/*AFAIK this must be done for every new screenmode*/
status_t g400_acc_init()
{
	/*MACCESS - for 2D, only pixel width is important > all others can be 0*/
	switch(si->dm.space)
	{
	case B_CMAP8:
		ACCW(MACCESS,0);
		break;
	case B_RGB15_LITTLE:case B_RGB16_LITTLE:
		ACCW(MACCESS,1); 
		break;
	case B_RGB32_LITTLE:case B_RGBA32_LITTLE:
		ACCW(MACCESS,2);
		break;
	default:
		LOG(3,"ACC: init, invalid bit depth\n");
		return B_ERROR;
	}

	/*PITCH*/
	if (si->dm.virtual_width&0x1F)
	{
		LOG(3,"ACC: can not accelerate, pitch is not multiple of 32 pixels\n");
		return B_ERROR;
	}
	ACCW(PITCH,(si->dm.virtual_width)&0x1FFF); /*use hardware Y decoding*/

	/*PLNWT - plane write mask*/
	ACCW(PLNWT,0xFFFFFFFF); /*all planes are written*/
	
	/*DSTORG - location of active screen in framebuffer*/
	ACCW(DSTORG,(si->fbc.frame_buffer)-(si->framebuffer));

	/*init source address - same as dest*/
	ACCW(SRCORG,(si->fbc.frame_buffer)-(si->framebuffer));

	/*clipping*/
	ACCW(CXBNDRY,((si->dm.virtual_width -1)<<16)|(0)); /*i.e. highest and lowest right pixel value*/
	ACCW(YTOP,0);
	ACCW(YBOT,(si->dm.virtual_height*si->dm.virtual_width)-1); /*y address must be linear*/

	return B_OK;
}

/*screen to screen blit - i.e. move windows around*/
status_t g400_acc_blit(uint16 xs,uint16 ys,uint16 xd,uint16 yd,uint16 w,uint16 h)
{
	uint32 t_start,t_end,offset;
	uint32 b_start,b_end;

	/*find where the top,bottom and offset are*/
	offset = si->dm.virtual_width;

	t_end = t_start = xs + (offset*ys);
	t_end += w;

	b_end = b_start = xs + (offset*(ys+h));
	b_end +=w;

	/*find which quadrant */
	switch((yd>ys)|((xd>xs)<<1))
	{
	case 0: /*L->R,down*/ 
		ACCW(SGN,0);

		ACCW(AR3,t_start);
		ACCW(AR0,t_end);
		ACCW(AR5,offset);

		ACCW(YDSTLEN,(yd<<16)|(h+1));
		break;
	case 1: /*L->R,up*/
		ACCW(SGN,4);

		ACCW(AR3,b_start);
		ACCW(AR0,b_end);
		ACCW(AR5,-offset);

		ACCW(YDSTLEN,((yd+h)<<16)|(h+1));
		break;
	case 2: /*R->L,down*/
		ACCW(SGN,1);

		ACCW(AR3,t_end);
		ACCW(AR0,t_start);
		ACCW(AR5,offset);

		ACCW(YDSTLEN,(yd<<16)|(h+1));
		break;
	case 3: /*R->L,up*/
		ACCW(SGN,5);

		ACCW(AR3,b_end);
		ACCW(AR0,b_start);
		ACCW(AR5,-offset);

		ACCW(YDSTLEN,((yd+h)<<16)|(h+1));
		break;
	}
	ACCW(FXBNDRY,((xd+w)<<16)|xd);
	
	/*do the blit*/
	ACCGO(DWGCTL,0x040C4018);

	return B_OK;
}

/*rectangle fill*/
/*colorIndex,fill_rect_params,count*/
status_t g400_acc_rectangle(uint32 xs,uint32 xe,uint32 ys,uint32 yl,uint32 col)
{
/*
	FXBNDRY - left and right coordinates    a
	YDSTLEN - y start and no of lines       a
	(or YDST and LEN)                       
	DWGCTL - atype must be RSTR or BLK      a
	FCOL - foreground colour                a
*/

	ACCW(FXBNDRY,(xe<<16)|xs); /*set x start and end*/
	ACCW(YDSTLEN,(ys<<16)|yl); /*set y start and length*/
	ACCW(FCOL,col);            /*set colour*/

	if (si->dm.space==B_CMAP8 || si->ps.sdram)
	{
		ACCGO(DWGCTL,0x400C7814);
	}
	else
	{
		ACCGO(DWGCTL,0x400C7844);
	}

	return B_OK;
}

/*rectangle invert*/
/*colorIndex,fill_rect_params,count*/
status_t g400_acc_rectangle_invert(uint32 xs,uint32 xe,uint32 ys,uint32 yl,uint32 col)
{
/*
	FXBNDRY - left and right coordinates    a
	YDSTLEN - y start and no of lines       a
	(or YDST and LEN)                       
	DWGCTL - atype must be RSTR or BLK      a
	FCOL - foreground colour                a
*/

	ACCW(FXBNDRY,(xe<<16)|xs); /*set x start and end*/
	ACCW(YDSTLEN,(ys<<16)|yl); /*set y start and length*/
	ACCW(FCOL,col);            /*set colour*/
	
	ACCGO(DWGCTL,0x40057814);   /*draw it! top nibble is c is clipping enabled*/

	return B_OK;
}
