/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	modification to call G400 driver and mess-ups - Mark Watson
*/

#include "acc_std.h"

/*
	Return the current display mode.  The only time you might return an
	error is if a mode hasn't been set.
*/
status_t GET_DISPLAY_MODE(display_mode *current_mode) {
	/* easy for us, we return the last mode we set */
	*current_mode = si->dm;
	return B_OK;
}

/*
	Return the frame buffer configuration information.
*/
status_t GET_FRAME_BUFFER_CONFIG(frame_buffer_config *afb) {
	/* easy again, as the last mode set stored the info in a convienient form */
	*afb = si->fbc;
	return B_OK;
}

/*
	Return the maximum and minium pixel clock limits for the specified mode.
*/
status_t GET_PIXEL_CLOCK_LIMITS(display_mode *dm, uint32 *low, uint32 *high) {
/*
	Note that we're not making any guarantees about the ability of the attached
	display to handle pixel clocks within the limits we return.  A future monitor
	capablilities database will post-process this information.
*/
	uint32 total_pix = (uint32)dm->timing.h_total * (uint32)dm->timing.v_total;
	uint32 clock_limit;

	/* max pixel clock is pixel depth independant */
	clock_limit=si->ps.pix_clk_max/1000.0;
	
	/* lower limit of about 48Hz vertical refresh */
	*low = (total_pix * 48L) / 1000L;
	if (*low > clock_limit) return B_ERROR;
	*high = clock_limit;
	return B_OK;
}

/*
	Return the semaphore id that will be used to signal a vertical retrace
	occured.
*/
sem_id ACCELERANT_RETRACE_SEMAPHORE(void) {
	/*
	NOTE:
		The kernel driver created this for us.  We don't know if the system is
		using real interrupts, or if we're faking it, and we don't care.
		If we choose not to support this at all, we'd just return B_ERROR here,
		and the user wouldn't get any kind of vertical retrace support.
	*/
	return si->vblank;
}
