/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	modification to call g400 functions and mess ups - Mark Watson
*/

#include "acc_std.h"

status_t SET_CURSOR_SHAPE(uint16 width, uint16 height, uint16 hot_x, uint16 hot_y, uint8 *andMask, uint8 *xorMask) {

	/* NOTE: Currently, for BeOS, cursor width and height must be equal to 16. */

	if ((width != 16) || (height != 16))
	{
		return B_ERROR;
	}
	else if ((hot_x >= width) || (hot_y >= height))
	{
		return B_ERROR;
	}
	else
	{
		g400_dac_cursor_define(andMask,xorMask);		

		/* Update cursor variables appropriately. */
		si->cursor.width = width;
		si->cursor.height = height;
		si->cursor.hot_x = hot_x;
		si->cursor.hot_y = hot_y;
	}

	return B_OK;
}

/*
Move the cursor to the specified position on the desktop.  If we're
using some kind of virtual desktop, adjust the display start position
accordingly and position the cursor in the proper "virtual" location.
*/
void MOVE_CURSOR(uint16 x, uint16 y) {

	bool move_screen = false;
	uint16 hds = si->dm.h_display_start;	/* the current horizontal starting pixel */
	uint16 vds = si->dm.v_display_start;	/* the current vertical starting line */
	uint16 h_adjust;                        /* minimum amount to scroll*/

	switch(si->dm.space)
	{
	case B_CMAP8:
		h_adjust=7;
		break;
	case B_RGB15_LITTLE:case B_RGB16_LITTLE:
		h_adjust=3;
		break;
	case B_RGB32_LITTLE:
		h_adjust=1;
		break;
	default:
		h_adjust=7;
	}

	/* clamp cursor to virtual display */
	if (x >= si->dm.virtual_width) x = si->dm.virtual_width - 1;
	if (y >= si->dm.virtual_height) y = si->dm.virtual_height - 1;

	/* adjust h/v_display_start to move cursor onto screen */
	if (x >= (si->dm.timing.h_display + hds)) {
		hds = ((x - si->dm.timing.h_display) + 1 + h_adjust) & ~h_adjust;
		move_screen = true;
	} else if (x < hds) {
		hds = x & ~h_adjust;
		move_screen = true;
	}
	if (y >= (si->dm.timing.v_display + vds)) {
		vds = y - si->dm.timing.v_display + 1;
		move_screen = true;
	} else if (y < vds) {
		vds = y;
		move_screen = true;
	}
	/* reposition the desktop on the display if required */
	if (move_screen) MOVE_DISPLAY(hds,vds);

	/* put cursor in correct physical position */
	x -= hds + si->cursor.hot_x;
	y -= vds + si->cursor.hot_y;

	/* position the cursor on the display */
	g400_dac_cursor_position(x,y);
}

void SHOW_CURSOR(bool is_visible) {

	if (is_visible)	{
		g400_dac_cursor_show();
	} else {
		g400_dac_cursor_hide();
	}
	/* record for our info */
	si->cursor.is_visible = is_visible;
}
