/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	Modifications to call G400 functions and mess-ups - Mark Watson
*/

#include "acc_std.h"

#define STICKY_REGS 1

void SCREEN_TO_SCREEN_BLIT(engine_token *et, blit_params *list, uint32 count) {
	int i;

	/*do each blit*/
	i=0;
	while (count--)
	{
		g400_acc_blit
		(
			list[i].src_left,
			list[i].src_top,
			list[i].dest_left,
			list[i].dest_top,
			list[i].width,
			list[i].height
		);
		i++;
	}
}

void FILL_RECTANGLE(engine_token *et, uint32 colorIndex, fill_rect_params *list, uint32 count) {
	int i;

	/*draw each rectangle*/
	i=0;
	while (count--)
	{
		g400_acc_rectangle
		(
			list[i].left,
			(list[i].right)+1,
			list[i].top,
			(list[i].bottom-list[i].top)+1,
			colorIndex
		);
		i++;
	}
}

void INVERT_RECTANGLE(engine_token *et, fill_rect_params *list, uint32 count) {
	int i;

	/*draw each rectangle*/
	i=0;
	while (count--)
	{
		g400_acc_rectangle_invert
		(
			list[i].left,
			(list[i].right)+1,
			list[i].top,
			(list[i].bottom-list[i].top)+1,
			0
		);
		i++;
	}
}

void FILL_SPAN(engine_token *et, uint32 colorIndex, uint16 *list, uint32 count) {
	int i;

	/*draw each span*/
	i=0;
	while (count--)
	{
		g400_acc_rectangle
		(
			list[i+1],
			list[i+2]+1,
			list[i],
			1,
			colorIndex
		);
		i+=3;
	}
}
